/*!
  \file
  \brief RectUtils のテスト

  \author Satofumi KAMIMURA

  $Id: TestRectUtils.cpp 899 2009-05-17 21:36:48Z satofumi $
*/

#include "TestRectUtils.h"
#include "RectUtils.h"

using namespace qrk;
using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestRectUtils);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestRectUtils, "TestRectUtils");


void TestRectUtils::isInnerTest(void)
{
  Rect<long> rect(5, 5, 5, 5);

  CPPUNIT_ASSERT(isInner(rect, Point<long>(7, 7)));
  CPPUNIT_ASSERT(! isInner(rect, Point<long>(-1, 7)));
  CPPUNIT_ASSERT(! isInner(rect, Point<long>(13, 7)));
  CPPUNIT_ASSERT(! isInner(rect, Point<long>(7, -1)));
  CPPUNIT_ASSERT(! isInner(rect, Point<long>(7, 13)));

  CPPUNIT_ASSERT(! isInner(rect, Point<long>(4, 7)));
  CPPUNIT_ASSERT(isInner(rect, Point<long>(5, 7)));
  CPPUNIT_ASSERT(isInner(rect, Point<long>(9, 7)));
  CPPUNIT_ASSERT(! isInner(rect, Point<long>(10, 7)));
}
