#ifndef QRK_ROTATION_H
#define QRK_ROTATION_H

/*!
  \file
  \brief 回転

  \author Satofumi KAMIMURA

  $Id: Rotate.h 1402 2009-10-11 12:45:16Z satofumi $
*/

#include "Angle.h"


namespace qrk
{
  /*!
    \brief 回転演算

    \param[in] position 回転前の位置
    \param[in] angle 回転させる角度

    \return 回転後の位置
  */
  template<class T>
  Position<T> rotate(const Position<T>& position, const Angle& angle)
  {
    double radian = angle.to_rad();
    T x =
      static_cast<T>((position.x * cos(radian)) - (position.y * sin(radian)));
    T y =
      static_cast<T>((position.x * sin(radian)) + (position.y * cos(radian)));

    return Position<T>(x, y, rad(position.angle.to_rad() + radian));
  }
}

#endif /* !QRK_ROTATION_H */
