#ifndef QRK_POSITION_UTILS_H
#define QRK_POSITION_UTILS_H

/*!
  \file
  \brief 位置の補助関数

  \author Satofumi KAMIMURA

  $Id: PositionUtils.h 1219 2009-08-14 02:59:46Z satofumi $
*/

#include "MathUtils.h"


namespace qrk
{
  /*!
    \brief 位置の垂線との距離を返す

    !!! 図

    \return 位置に定義した垂線との距離
  */
  template <class T>
  T lengthToLine(const Point<T>& point, const Position<T>& position)
  {
    T x_diff = point.x - position.x;
    T y_diff = point.y - position.y;
    double radian = position.rad();

    return static_cast<T>((x_diff * cos(radian)) + (y_diff * sin(radian)));
  }
}

#endif /* !QRK_POSITION_UTILS_H */
