#ifndef QRK_POSITION_3D_H
#define QRK_POSITION_3D_H

/*!
  \file
  \brief 位置の型定義 (3D)

  \author Satofumi KAMIMURA

  $Id: Position3d.h 1273 2009-09-01 21:54:16Z satofumi $
*/

#include "Position.h"


namespace qrk
{
  /*!
    \brief 位置の型定義 (3D)
  */
  template<class T>
  class Position3d
  {
  public:
    T x;                        //!< X 位置
    T y;                        //!< Y 位置
    T z;                        //!< Z 位置

    // !!! 回転情報


    Position3d(void) : x(0), y(0), z(0)
    {
    }


    Position3d(const Position3d& rhs) : x(rhs.x), y(rhs.y), z(rhs.z)
    {
    }


    Position3d(T x_, T y_, T z_) : x(x_), y(y_), z(z_)
    {
    }


    Position3d& operator = (const Position3d& rhs)
    {
      this->x = rhs.x;
      this->y = rhs.y;
      this->z = rhs.z;

      return *this;
    }


    Position3d& operator = (const Position<T>& rhs)
    {
      this->x = rhs.x;
      this->y = rhs.y;
      this->z = 0;

      // !!! 回転情報

      return *this;
    }
  };
}

#endif /* !QRK_POSITION_3D_H */
