#ifndef TEST_COORDINATE_H
#define TEST_COORDINATE_H

/*!
  \file
  \brief Coordinate のテスト

  \author Satofumi KAMIMURA

  $Id: TestCoordinate.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include <cppunit/extensions/HelperMacros.h>


/*!
  \brief Coordinate のテストクラス
*/
class TestCoordinate : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE(TestCoordinate);
  CPPUNIT_TEST(initializeTest);
  CPPUNIT_TEST(setOriginToTest);
  CPPUNIT_TEST(treeTest);
  CPPUNIT_TEST(basicConvertTest);
  CPPUNIT_TEST(pointPositionTest);
  CPPUNIT_TEST_SUITE_END();

public:
  void initializeTest(void);
  void setOriginToTest(void);
  void treeTest(void);
  void basicConvertTest(void);
  void pointPositionTest(void);
};

#endif /* !TEST_COORDINATE_H */
