/*!
  \example controller/samples/motionPlusDirection.cpp

  Wii Motion Plus を用いた向き推定

  \author Satofumi KAMIMURA

  $Id: motionPlusDirection.cpp 1392 2009-10-10 10:59:39Z satofumi $
*/

#include "WiiJoystick.h"
#include "Angle.h"
#include "delay.h"
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  WiiJoystick wii;
  if (! wii.connect()) {
    printf("WiiJoystick::connect: %s\n", wii.what());
    exit(1);
  }
  printf("O.K.\n");

  Angle z;
  while (1) {
    Angle x_axis;
    Angle y_axis;
    Angle z_axis;
    wii.rotation(x_axis, y_axis, z_axis);

    // 積分した向きの表示
    cout << z_axis.to_deg() << ", "
         << x_axis.to_deg() << ", "
         << y_axis.to_deg() << endl;

    delay(1);
  }
}
