/*!
  \example controller/samples/ViewJoystickInfo.cpp

  Joystick 情報の表示

  \author Satofumi KAMIMURA

  $Id: ViewJoystickInfo.cpp 1392 2009-10-10 10:59:39Z satofumi $
*/

#include "ViewJoystickInfo.h"
#include "Joystick.h"
#include "delay.h"
#include "ticks.h"
#include <SDL.h>
#include <iostream>

using namespace qrk;
using namespace std;


namespace
{
  bool printJoystickInput(Joystick& joystick,
                          size_t axis_num, size_t buttons_num)
  {
    bool haveInput = false;

    for (size_t i = 0; i < axis_num; ++i) {
      short value = joystick.axisValue(i);
      cout << value << ", ";
      if (value != 0) {
        haveInput = true;
      }
    }

    for (size_t i = 0; i < buttons_num; ++i) {
      bool pressed = joystick.isButtonPressed(i);
      cout << ((pressed) ? '*' : '_') << " ";
      if (pressed != false) {
        haveInput = true;
      }
    }
    cout << endl;

    return haveInput;
  }
}


void ViewJoystickInfo(Joystick& joystick)
{
  size_t axis_num = joystick.axisNum();
  size_t buttons_num = joystick.buttonsNum();

  // 入力情報の出力
  int lastInputTicks = ticks();
  while (1) {
    // ５秒以上、ボタン入力がなければ終了する
    if (ticks() - lastInputTicks > 5000) {
      break;
    }

    // ジョイスティックへの入力情報を表示
    SDL_Event event;
    while (SDL_PollEvent(&event)) {
      joystick.setEvent(&event);
      lastInputTicks = SDL_GetTicks();
    }

    printJoystickInput(joystick, axis_num, buttons_num);

    // 入力を表示
    delay(200);
  }
}
