#ifndef QRK_USB_JOYSTICK_H
#define QRK_USB_JOYSTICK_H

/*!
  \file
  \brief USB ジョイスティック

  \author Satofumi KAMIMURA

  $Id: UsbJoystick.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Joystick.h"
#include <memory>


namespace qrk
{
  //! USB ジョイスティック
  class UsbJoystick : public Joystick
  {
  public:
    UsbJoystick(void);
    ~UsbJoystick(void);

    const char* what(void) const;
    bool connect(int id = 0);
    void disconnect(void);
    bool isConnected(void) const;
    size_t axisNum(void) const;
    int axisValue(size_t index);
    size_t buttonsNum(void) const;
    bool isButtonPressed(size_t index);

    /*!
      \brief ジョイスティック数を返す

      \return 認識しているジョイスティック数を返す
    */
    size_t joystickNum(void);

    void setEvent(void* event);

  private:
    UsbJoystick(const UsbJoystick& rhs);
    UsbJoystick& operator = (const UsbJoystick& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_JOYSTICK_H */
