/*!
  \file
  \brief MTv

  \author Satofumi KAMIMURA

  $Id: readwriteSample.cpp 1408 2009-10-14 20:55:13Z satofumi $
*/

#include "SerialDevice.h"
//#include <time.h>
#include "ticks.h"

using namespace qrk;


#if 0
int ticks(void)
{
  return (int)(clock() / (CLOCKS_PER_SEC / 1000.0));
}
#endif


int main(int argc, char *argv[])
{
  //const char device[] = "COM4";
  const char device[] = "/dev/ttyACM0";

  SerialDevice con;
  if (! con.connect(device, 115200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  int n = con.send("QT\r", 3);
  printf("n = %d\n", n);

  //n = con.send("SCIP2.0\r", 8);
  //n = con.send("MD0180090002000\r", 16);
  n = con.send("MD0000108000000\r", 16);
  printf("n = %d\n", n);

  while (1) {
    enum { BufferSize = 4096 };
    char buffer[BufferSize];
    int first_ticks = ticks();
    n = con.receive(buffer, BufferSize, 1);
    printf("spent %d [msec], ", ticks() - first_ticks);
    printf("%d: n = %d\n", ticks(), n);

    for (int i = 0; i < n; ++i) {
      char ch = buffer[i];
      if (isprint(ch)) {
        printf("%c", ch);
      } else {
        printf("[%02x]", (unsigned char)ch);
      }
    }
    if (n > 0) {
      printf("\n");
    }
  }

  return 0;
}
