/*!
  \file
  \brief MTv

  \author Satofumi KAMIMURA

  $Id: hugeSendSample.cpp 1408 2009-10-14 20:55:13Z satofumi $
*/

#include "SerialDevice.h"
#include "ticks.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  //const char device[] = "COM4";
  const char device[] = "/dev/ttyACM0";

  SerialDevice con;
  if (! con.connect(device, 115200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  enum { BufferSize = 2048 };
  char buffer[BufferSize];
  memset(buffer, '0', BufferSize);
  buffer[0] = '1';

  char recv_buffer[BufferSize];
  while (1) {
    con.send(buffer, BufferSize);
    con.receive(recv_buffer, BufferSize, 10);
    fprintf(stderr, ".");
  }

  return 0;
}
