/*!
  \file
  \brief MTv

  \author Satofumi KAMIMURA

  $Id: readwriteSample.cpp 1303 2009-09-16 02:31:54Z satofumi $
*/

#include "serial_ctrl.h"
#include "ticks.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
//#include <windows.h>


int main(int argc, char *argv[])
{
  enum { TimerResolution = 1 };

  //const char device[] = "COM4";
  const char device[] = "/dev/ttyACM0";
  serial_t con;
  int i;

  //timeBeginPeriod(TimerResolution);

  if (serial_connect(&con, device, 115200) < 0) {
    printf("SerialDevice::connect() fail: %s\n", device);
    exit(1);
  }

  int n = serial_send(&con, "QT\r", 3);
  printf("n = %d\n", n);

  n = serial_send(&con, "MD0180090002000\r", 16);
  printf("n = %d\n", n);

  while (1) {
    enum { BufferSize = 4096 };
    char buffer[BufferSize];
    int first_ticks = ticks();
    n = serial_recv(&con, buffer, BufferSize, 1);
    printf("spent %d [msec], ", ticks() - first_ticks);
    printf("%d: n = %d\n", ticks(), n);

    for (i = 0; i < n; ++i) {
      char ch = buffer[i];
      if (isprint(ch)) {
        printf("%c", ch);
      } else {
        printf("[%02x]", (unsigned char)ch);
      }
    }
    if (n > 0) {
      printf("\n");
    }
  }

  //timeEndPeriod(TimerResolution);

  return 0;
}
