#ifndef QRK_STANDARD_IO_H
#define QRK_STANDARD_IO_H

/*!
  \file
  \brief 標準入出力

  \author Satofumi KAMIMURA

  $Id: StandardIo.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Connection.h"
#include <memory>


namespace qrk
{
  /*!
    \brief 標準入出力クラス
  */
  class StandardIo : public Connection
  {
  public:
    StandardIo(void);
    ~StandardIo(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = 0);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void) const;
    bool isConnected(void) const;
    int send(const char* data, size_t count);
    int receive(char* data, size_t count, int timeout);
    size_t size(void) const;
    void flush(void);
    void clear(void);
    void ungetc(const char ch);

  private:
    StandardIo(const StandardIo& rhs);
    StandardIo& operator = (const StandardIo& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_STANDARD_IO_H */
