#ifndef QRK_CUSTOM_CONNECTION_H
#define QRK_CUSTOM_CONNECTION_H

/*!
  \file
  \brief 送受信データを任意に設定できる接続クラス

  \author Satofumi KAMIMURA

  $Id: CustomConnection.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Connection.h"
#include <string>
#include <memory>


namespace qrk
{
  /*!
    \brief 送受信データを任意に設定できる接続クラス
  */
  class CustomConnection : public Connection
  {
  public:
    enum { NoTimeout = -1 };

    CustomConnection(void);
    ~CustomConnection(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void) const;
    bool isConnected(void) const;
    int send(const char* data, size_t count);
    int receive(char* data, size_t count, int timeout);
    size_t size(void) const;
    void flush(void);
    void clear(void);
    void ungetc(const char ch);

    void setReadData(const char* data, size_t count);
    void setReadData(std::string data);
    void readSendData(char* data, size_t count);

  private:
    CustomConnection(const CustomConnection& rhs);
    CustomConnection& operator = (const CustomConnection& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_CUSTOM_CONNECTION_H */
