/*!
  \file
  \brief 送受信データを任意に設定できる接続クラス

  \author Satofumi KAMIMURA

  $Id: CustomConnection.cpp 1386 2009-10-09 08:00:11Z satofumi $
*/

#include "CustomConnection.h"
#include "RingBuffer.h"

using namespace qrk;
using namespace std;


struct CustomConnection::pImpl
{
  long baudrate_;
  RingBuffer<char> recv_buffer_;
  RingBuffer<char> send_buffer_;


  pImpl(void) : baudrate_(0)
  {
  }
};


CustomConnection::CustomConnection(void) : pimpl(new pImpl)
{
}


CustomConnection::~CustomConnection(void)
{
}


const char* CustomConnection::what(void) const
{
  return "Not implemented.";
}


bool CustomConnection::connect(const char* device, long baudrate)
{
  static_cast<void>(device);
  static_cast<void>(baudrate);

  // !!!
  return true;
}


void CustomConnection::disconnect(void)
{
  // !!!
}


bool CustomConnection::setBaudrate(long baudrate)
{
  pimpl->baudrate_ = baudrate;
  return true;
}


long CustomConnection::baudrate(void) const
{
  return pimpl->baudrate_;
}


bool CustomConnection::isConnected(void) const
{
  // !!!
  return false;
}


int CustomConnection::send(const char* data, size_t count)
{
  static_cast<void>(data);
  static_cast<void>(count);

  // !!!
  return count;
}


int CustomConnection::receive(char* data, size_t count, int timeout)
{
  static_cast<void>(timeout);

  int n = std::min(pimpl->recv_buffer_.size(), count);
  pimpl->recv_buffer_.get(data, n);
  return n;
}


size_t CustomConnection::size(void) const
{
  return pimpl->recv_buffer_.size();
}


void CustomConnection::flush(void)
{
  // !!!
}


void CustomConnection::clear(void)
{
  // 登録内容を全てクリアする
  pimpl->recv_buffer_.clear();
  pimpl->send_buffer_.clear();
}


void CustomConnection::ungetc(const char ch)
{
  pimpl->recv_buffer_.ungetc(ch);
}


void CustomConnection::setReadData(const char* data, size_t count)
{
  pimpl->recv_buffer_.put(data, count);
}


void CustomConnection::setReadData(std::string data)
{
  pimpl->recv_buffer_.put(data.c_str(), data.size());
}


void CustomConnection::readSendData(char* data, size_t count)
{
  pimpl->send_buffer_.put(data, count);
}
