#ifndef QRK_CONNECTION_RECORDER_H
#define QRK_CONNECTION_RECORDER_H

/*!
  \file
  \brief 通信データの記録

  \author Satofumi KAMIMURA

  $Id: ConnectionRecorder.h 1414 2009-10-14 23:14:02Z satofumi $

  \todo データ取得タイミングの概念を導入するか検討する
*/

#include <memory>
#include "Connection.h"


namespace qrk
{
  /*!
    \brief 通信データの記録クラス
  */
  class ConnectionRecorder : public Connection
  {
  public:
    enum { NoTimeout = -1 };

    ConnectionRecorder(Connection* con);
    ~ConnectionRecorder(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate);
    void disconnect(void);
    bool setBaudrate(long baudrate);
    long baudrate(void) const;
    bool isConnected(void) const;
    int send(const char* data, size_t count);
    int receive(char* data, size_t count, int timeout);
    size_t size(void) const;
    void flush(void);
    void clear(void);
    void ungetc(const char ch);

    /*!
      \brief 記録用のファイル名を変更する

      以降の送受信データは、以下の２つのファイル名に出力される

      - <ファイルの基本名>_send.txt
      - <ファイルの基本名>_receive.txt

      \param[in] basename ファイルの基本名
    */
    void setBasename(const char* basename);

  private:
    ConnectionRecorder(void);
    ConnectionRecorder(const ConnectionRecorder& rhs);
    ConnectionRecorder& operator = (const ConnectionRecorder& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_CONNECTION_RECORDER_H */
