/*!
  \file
  \brief MovingMedian のテスト

  \author Satofumi KAMIMURA

  $Id: TestMovingMedian.cpp 1264 2009-08-28 11:11:52Z satofumi $
*/

#include "TestMovingMedian.h"
#include "MovingMedian.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestMovingMedian);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestMovingMedian, "TestMovingMedian");


void TestMovingMedian::compileTest(void)
{
  MovingMedian<int> median(3);
}


void TestMovingMedian::setTest(void)
{
  MovingMedian<int> median(3);

  CPPUNIT_ASSERT_EQUAL(0, median.median());

  median.setMedianValue(1);
  CPPUNIT_ASSERT_EQUAL(1, median.median());

  median.setMedianValue(-2);
  CPPUNIT_ASSERT_EQUAL(-2, median.median());
}


void TestMovingMedian::medianTest(void)
{
  MovingMedian<int> median(3);
  CPPUNIT_ASSERT_EQUAL(0, median.median());

  // 0, 0, 1
  median.push_back(1);
  CPPUNIT_ASSERT_EQUAL(0, median.median());

  // 0, 1, 1
  median.push_back(1);
  CPPUNIT_ASSERT_EQUAL(1, median.median());

  // 1, 1, 3
  median.push_back(3);
  CPPUNIT_ASSERT_EQUAL(1, median.median());

  // 1, 3, 2
  median.push_back(2);
  CPPUNIT_ASSERT_EQUAL(2, median.median());

  // 3, 2, 1
  median.push_back(1);
  CPPUNIT_ASSERT_EQUAL(2, median.median());

  // 2, 1, -1
  median.push_back(-1);
  CPPUNIT_ASSERT_EQUAL(1, median.median());

  // 1, -1, 0
  median.push_back(0);
  CPPUNIT_ASSERT_EQUAL(0, median.median());
}
