/*!
  \file
  \brief MovingAverage のテスト

  \author Satofumi KAMIMURA

  $Id: TestMovingAverage.cpp 780 2009-05-05 08:16:41Z satofumi $
*/

#include "TestMovingAverage.h"
#include "MovingAverage.h"


CPPUNIT_TEST_SUITE_REGISTRATION(MovingAverageTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(MovingAverageTest, "MovingAverageTest");

using namespace qrk;


void MovingAverageTest::compileTest(void)
{
  MovingAverage<int> buffer(1);
}


void MovingAverageTest::firstValueTest(void)
{
  MovingAverage<int> int_buffer1(1);
  CPPUNIT_ASSERT_EQUAL(0, int_buffer1.average());

  MovingAverage<int> int_buffer2(3);
  CPPUNIT_ASSERT_EQUAL(0, int_buffer2.average());

  MovingAverage<double> double_buffer(3);
  CPPUNIT_ASSERT_EQUAL(0.0, double_buffer.average());
}


void MovingAverageTest::setAverageValueTest(void)
{
  MovingAverage<int> int_buffer1(1);
  int_buffer1.setAverageValue(2);
  CPPUNIT_ASSERT_EQUAL(2, int_buffer1.average());

  MovingAverage<int> int_buffer2(3);
  int_buffer2.setAverageValue(4);
  CPPUNIT_ASSERT_EQUAL(4, int_buffer2.average());

  MovingAverage<double> double_buffer(1);
  double_buffer.setAverageValue(2.34);
  CPPUNIT_ASSERT_EQUAL(2.34, double_buffer.average());
}


void MovingAverageTest::pushTest(void)
{
  MovingAverage<int> buffer(3);

  buffer.push_back(3);
  CPPUNIT_ASSERT_EQUAL(1, buffer.average());

  buffer.push_back(3);
  CPPUNIT_ASSERT_EQUAL(2, buffer.average());

  buffer.push_back(-6);
  CPPUNIT_ASSERT_EQUAL(0, buffer.average());

  buffer.push_back(0);
  CPPUNIT_ASSERT_EQUAL(-1, buffer.average());

  buffer.push_back(0);
  CPPUNIT_ASSERT_EQUAL(-2, buffer.average());

  buffer.push_back(0);
  CPPUNIT_ASSERT_EQUAL(0, buffer.average());
}


void MovingAverageTest::minusValueTest(void)
{
  MovingAverage<double> buffer(1);

  buffer.push_back(0.0);
  CPPUNIT_ASSERT_EQUAL(0.0, buffer.average());

  buffer.push_back(-1.0);
  CPPUNIT_ASSERT_EQUAL(-1.0, buffer.average());

  buffer.push_back(-4.0);
  CPPUNIT_ASSERT_EQUAL(-4.0, buffer.average());

  buffer.push_back(-0.04);
  CPPUNIT_ASSERT_EQUAL(-0.04, buffer.average());
}
