/*!
  \example SdlMixerSample.cpp
  \brief SDL_mixer の動作サンプル

  \author Satofumi KAMIMURA

  $Id: SdlMixerSample.cpp 900 2009-05-18 02:09:27Z satofumi $
*/

#include "delay.h"
#include <SDL_mixer.h>
#include <SDL.h>
#include <iostream>

using namespace qrk;
using namespace std;


namespace
{
  bool initializeAudio(void)
  {
    if (SDL_Init(SDL_INIT_AUDIO) < 0) {
      return false;
    }
    atexit(SDL_Quit);

    if (Mix_OpenAudio(MIX_DEFAULT_FREQUENCY,
                      MIX_DEFAULT_FORMAT, MIX_DEFAULT_CHANNELS, 1024) < 0) {
      return false;
    }
    atexit(Mix_CloseAudio);

    enum { ChannelSize = 8 };
    Mix_AllocateChannels(ChannelSize);
    // cleanup 時に Mix_AllocateChannels(0) を呼び出してクリアすべき

    return true;
  }
}


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  if (! initializeAudio()) {
    cout << "Audio initialize: " << Mix_GetError() << endl;
  }

  // 音楽の再生
  // const char music_file[] = "music.mp3";
  // !!!

  // 効果音の再生
  // effect.wav というファイルを再生させる
  const char effect_file[] = "effect.wav";
  Mix_Chunk* chunk = Mix_LoadWAV(effect_file);
  if (! chunk) {
    cout << "Mix_LoadWAV: " << Mix_GetError() << endl;
    exit(1);
  }

  int channel_id = Mix_PlayChannel(-1, chunk, 0);

  // 効果音の再生が終わるまで待つ
  do {
    delay(100);
  } while (Mix_Playing(channel_id));

  Mix_FreeChunk(chunk);
  return 0;
}
