/*!
  \file
  \brief VDIP コンソールの制御用ターミナル

  \author Satofumi KAMIMURA

  VDIP1 を UART インターフェースで利用している

  $Id: vdip_terminal.c 789 2009-05-05 12:00:03Z satofumi $
*/

#include <7040S.H>
#include "sci_ctrl.h"
#include "imask_ctrl.h"

enum {
  CONSOLE_PORT = SCI_1,
  VDIP1_PORT = SCI_0,
};


int main(void) {
  int i;

  // シリアル通信の初期化
  for (i = 0; i < 2; ++i) {
    sci_init(i, 4);
  }
  imask_set(0);

  // _RESET 用に PE13 を出力設定
  // PE13 は、VDIP1 の RS# に接続
  PFC.PEIOR.WORD |= 0x2000;
  PE.DR.WORD |= 0x2000;

  // PE14 出力。Command Mode の場合、Hi 出力。Data Mode の場合、Lo 出力
  // PE14 は、VDIP1 の AD5 に接続
  PFC.PECR1.WORD &= ~0x3000;
  PFC.PEIOR.WORD |= 0x4000;
#if 0
  PE.DR.WORD |= 0x4000;         // Command Mode
#elese
  PE.DR.WORD &= ~0x4000;        // Data Mode
#endif

  while (1) {
    char ch = '\0';

    // VDIP1 からの受信メッセージを表示する
    if (sci_readable(VDIP1_PORT) != 0) {
      sci_read(VDIP1_PORT, &ch, 1);

      if ((ch == '\r') || (ch == '\n')) {
        // 改行のときは、LF CR に展開する
        sci_write(CONSOLE_PORT, "\r\n", 2);
      } else {
        sci_write(CONSOLE_PORT, &ch, 1);
      }
    }

    // VDIP1 へメッセージを送信
    if (sci_readable(CONSOLE_PORT) != 0) {
      sci_read(CONSOLE_PORT, &ch, 1);

      // '\n' は '\r' に置換して送信する。でないと VDIP1 に認識されない
      // (「Data Mode」のときは、関係ない)
      if (ch == '\n') {
        ch = '\r';
      }
      sci_write(VDIP1_PORT, &ch, 1);
    }
  }
}
