#ifndef QRK_CONNECTION_UTILS_H
#define QRK_CONNECTION_UTILS_H

/*!
  \file
  \brief Connection p⏕֐

  \author Satofumi KAMIMURA

  $Id: ConnectionUtils.h 783 2009-05-05 08:56:26Z satofumi $
*/

#include <cstddef>
#include <algorithm>


/*!
  \brief Quick Robot Develoment Kit.
*/
namespace qrk
{
  class Connection;


  /*!
    \brief sR[hԂ

    \retval true LF, CR ̂Ƃ
    \retval false LȊÔƂ
  */
  extern bool isLF(const char ch);


  /*!
    \brief Mf[^ǂݔ΂

    Connection::clear() Ƃ́A^CAEgԂw肵ēǂݔ΂_قȂ

    \param[in,out] con ʐM\[X
    \param[in] total_timeout ^CAEgԂ̏ [msec]
    \param[in] each_timeout Mf[^Ԃɂ^CAEgԂ̏ [msec]
  */
  extern void skip(Connection* con, int total_timeout, int each_timeout = 0);


  /*!
    \brief s܂ł̃f[^ǂݏo

    I[ \\0 tĕԂ

    \param[in,out] con ʐM\[X
    \param[out] buf Mobt@
    \param[in] count Mobt@̍őTCY
    \param[in] timeout ^CAEg [msec]

    \return M (MȂă^CAEgꍇ -1)
  */
  extern int readline(Connection* con, char* buf, const size_t count,
                      const int timeout);


  /*!
    \brief ڑIuWFNǧ

    a  b ̐ڑIuWFNgB
  */
  template <class T>
  void swapConnection(T& a, T& b)
  {
    Connection* t = a.connection();
    a.setConnection(b.connection());
    b.setConnection(t);
  }
};

#endif /* !QRK_CONNECTION_UTILS_H */
