#ifndef QRK_TICKS_CONTROL_WIDGET_H
#define QRK_TICKS_CONTROL_WIDGET_H

/*!
  \file
  \brief 時間再生の操作

  \author Satofumi KAMIMURA

  $Id: TicksControlWidget.h 1485 2009-11-02 01:30:50Z satofumi $
*/

#include "ui_TicksControlWidgetForm.h"
#include <memory>


namespace qrk
{
  class TicksControlWidget : public QWidget, private Ui::TicksControlWidgetForm
  {
    Q_OBJECT;

  public:
    TicksControlWidget(QWidget* parent = 0);
    ~TicksControlWidget(void);

    long ticks(void) const;

    void showTicks(void);
    void hideTicks(void);

    // !!! Close したときにイベントを投げるようにする

  private slots:
    void closeEvent(QCloseEvent* event);
    void updateTicks(void);
    void playPressed(void);
    void pausePressed(void);
    void speedUpPressed(void);
    void speedDownPressed(void);

  private:
    TicksControlWidget(const TicksControlWidget& rhs);
    TicksControlWidget& operator = (const TicksControlWidget& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !_TICKS_CONTROL_WIDGET_H */
