#ifndef ETHERNET_CONNECTION_WIDGET_H
#define ETHERNET_CONNECTION_WIDGET_H

/*!
  \file
  \brief Ethernet 接続用 Widget

  \author Satofumi KAMIMURA

  $Id: EthernetConnectionWidget.h 1726 2010-02-26 00:37:58Z satofumi $
*/

#include "ui_EthernetConnectionWidgetForm.h"
#include <string>
#include <memory>


namespace qrk
{
  class EthernetConnectionWidget
    : public QWidget, private Ui::EthernetConnectionWidgetForm
  {
    Q_OBJECT;

  public:
    EthernetConnectionWidget(QWidget* parent = 0);
    ~EthernetConnectionWidget(void);

    void setConnected(bool connected);
    bool isConnected(void) const;

    void setAddress(const std::string& address);
    std::string address(void) const;
    void setPort(unsigned short port);
    unsigned port(void) const;

    void setEnabled(bool enable);
    void setFocus(void);

  signals:
    void connectRequest(bool connection,
                        const std::string& address, unsigned short port);

  private slots:
    void connectPressed(bool checked);

  private:
    EthernetConnectionWidget(const EthernetConnectionWidget& rhs);
    EthernetConnectionWidget& operator = (const EthernetConnectionWidget& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !ETHERNET_CONNECTION_WIDGET_H */
