#ifndef SLOADER_WIDGET_H
#define SLOADER_WIDGET_H

/*!
  \file
  \brief S-format loader

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ui_SloaderWidgetForm.h"
#include <QWidget>
#include <memory>

class QCloseEvent;


class SloaderWidget : public QWidget, private Ui::SloaderWidgetForm
{
  Q_OBJECT;

public:
  SloaderWidget(QWidget* parent = 0);
  ~SloaderWidget(void);

  void setFile(QString file);

private slots:
  void closeEvent(QCloseEvent* event);
  void rescanDevice(void);
  void openFile(void);
  void loadFile(void);
  void transmitFailed(void);
  void transmitSuccessed(void);
  void displayReceiveData(void);
  void setSendText(void);

private:
  SloaderWidget(const SloaderWidget& rhs);
  SloaderWidget& operator = (const SloaderWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !SLOADER_WIDGET_H */
