/*!
  \file
  \brief ターゲット側の書き込みプログラム

  \author Satofumi KAMIMURA

  $Id: flash_host.cpp 1111 2009-07-05 21:06:28Z satofumi $
*/

#include "flash.h"
#include "delay.h"
#include <cstdio>

using namespace qrk;


int flash_data(unsigned long addr, const char *data)
{
  fprintf(stderr, "flush_data: %08lx: ", addr);

  for (int i = 0; i < 32; ++i) {
    fprintf(stderr, "%02x ", static_cast<unsigned char>(data[i]));
  }
  fprintf(stderr, "\n");

  // 最悪の場合の書き込み時間をエミュレート (573u 以上)
  delay(1);

  return 0;
}
