#ifndef S_FORMAT_SENDER_H
#define S_FORMAT_SENDER_H

/*!
  \file
  \brief S-Format ファイルの送信処理

  \author Satofumi KAMIMURA

  $Id: SformatSender.h 1468 2009-10-29 22:28:53Z satofumi $
*/

#include <memory>


namespace qrk
{
  class Connection;
}


//! S-Format データの送信
class SformatSender
{
public:
  SformatSender(qrk::Connection* connection, long baudrate);
  virtual ~SformatSender(void);

  virtual void progress(double percent)
  {
    static_cast<void>(percent);
  }

  const char* what(void) const;

  void setDumpFile(const char* file);

  bool send(const char* mot_file);
  bool jump(const char* mot_file);

private:
  SformatSender(void);
  SformatSender(const SformatSender& rhs);
  SformatSender& operator = (const SformatSender& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !S_FORMAT_SENDER_H */
