#!/usr/bin/ruby
# Satofumi KAMIMURA
# $Id: detectJpString.rb 1720 2010-02-22 14:14:29Z satofumi $

# 日本語文字を検出し、ファイル名と行番号を出力する
# ファイルの探索対象は、指定フォルダ内のファイル

require 'find'


# ディレクトリ内のファイルを走査
directory = "."
Dir.chdir(directory)
# !!! エラー処理をすべき
# !!! 移動に失敗したら、それとわかるエラーメッセージを出力すべき

Find.find('.') { |file|
  if FileTest.directory?(file)
    next
  end

  # 1byte ずつ読み出し、0x7f-0xff の範囲の文字があれば、日本語とみなす
  File.open(file) { |io|
    Find.prune if /.+\.svn/ =~ File.dirname(file)
    Find.prune if /.+\.libs/ =~ File.dirname(file)

    ext = File.extname(file)
    if ext == '.o' or ext == '.a' or File.executable?(file)
      next
    end

    error_detected = false
    line_count = 0

    # 最初のエラー文字の情報を表示して、次のファイルを処理する
    while (not error_detected) && (line = io.gets)
      line_count = line_count + 1
      byte_count = 0

      line.chomp.each_byte { |byte|

        if byte >= 0x7f && byte <= 0xff
          # emacs 形式のエラー出力
          print directory + "/" + file + ":" + line_count.to_s + ": " + byte_count.to_s + "\n"
          error_detected = true
          break
        end
        byte_count = byte_count + 1
      }
    end
  }
}
