#ifndef WRITER_WIDGET_H
#define WRITER_WIDGET_H

/*!
  \file
  \brief 書き込み用ウィジット

  \author Satofumi KAMIMURA

  $Id: WriterWidget.h 1101 2009-06-30 12:45:32Z satofumi $
*/

#include "ui_WriterWidgetForm.h"
#include <memory>


class WriterWidget : public QWidget, private Ui::WriterWidgetForm
{
  Q_OBJECT;

  WriterWidget(const WriterWidget& rhs);
  WriterWidget& operator = (const WriterWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void rescanPressed(void);
  void connectPressed(bool connection, const std::string& device);
  void fileUpdated(const QString& text);
  void pathPressed(void);
  void writePressed(void);

public:
  WriterWidget(QWidget* parent = 0);
  ~WriterWidget(void);
};

#endif /* !WRITER_WIDGET_H */
