#ifndef C_RANGE_VIEW_WIDGET_H
#define C_RANGE_VIEW_WIDGET_H

/*!
  \file
  \brief 範囲を 2D 表示するウィジット

  \author Satofumi KAMIMURA

  $Id: cRangeViewWidget.h 1299 2009-09-15 00:56:12Z satofumi $
*/

#include <QWidget>
#include <memory>

namespace qrk
{
  class RangeSensorParameter;
}
class cCaptureSettingWidget;


/*!
  \brief データ取得範囲の描画ウィジット
*/
class cRangeViewWidget : public QWidget
{
  Q_OBJECT;

  cRangeViewWidget(const cRangeViewWidget& rhs);
  cRangeViewWidget& operator = (const cRangeViewWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void paintEvent(QPaintEvent* event);

protected slots:
  void isRangeChanged(int first_index, int last_index);

public:
  cRangeViewWidget(cCaptureSettingWidget* parent = 0);
  ~cRangeViewWidget(void);

  void setParameter(const qrk::RangeSensorParameter& parameter);
};

#endif /* !C_RANGE_VIEW_WIDGET_H */
