/*!
  \file
  \brief 再生時の接続用スレッド

  \author Satofumi KAMIMURA

  $Id: cConnectThread.cpp 1727 2010-02-26 08:56:46Z satofumi $
*/

#include "cConnectThread.h"
#include "urg_ctrl.h"

using namespace std;


struct cConnectThread::pImpl
{
  urg_t& urg_;

  string device_;
  long baudrate_;


  pImpl(urg_t& urg)
    : urg_(urg), device_("dummy"), baudrate_(115200)
  {
  }
};


void cConnectThread::run(void)
{
  bool ret =
    (urg_connect(&pimpl->urg_,
                 pimpl->device_.c_str(), pimpl->baudrate_) < 0) ? false : true;
  emit connected(ret);
}


cConnectThread::cConnectThread(urg_t& urg) : pimpl(new pImpl(urg))
{
}


cConnectThread::~cConnectThread(void)
{
}


void cConnectThread::setConnectSettings(const string& device, long baudrate)
{
  pimpl->device_ = device;
  pimpl->baudrate_ = baudrate;
}
