/*!
  \file
  \brief 待機関数

  \author Satofumi KAMIMURA

  $Id: system_delay.cpp 439 2009-01-03 05:01:55Z satofumi $
*/

#include "system_delay.h"
#include <QThread>


namespace
{
  class DelayThread : public QThread
  {
    int delay_msec_;

  public:
    DelayThread(int msec) : delay_msec_(msec)
    {
    }


    void run(void)
    {
      QThread::msleep(delay_msec_);
    }
  };
}


void qrk::system_delay(int msec)
{
  if (msec > 0) {
    DelayThread delay_thread(msec);
    delay_thread.run();
    delay_thread.wait();
  }
}
