/*!
  \file
  \brief URG データの描画ツール

  \author Satofumi KAMIMURA

  $Id: main.cpp 1939 2010-11-22 02:05:24Z satofumi $
*/

#include "UrgViewerWindow.h"
#include <QApplication>
#include <QTranslator>


//! main
int main(int argc, char *argv[])
{
  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("UrgViewer_" + locale);
  app.installTranslator(&translator);

  UrgViewerWindow window(argc, argv);
  window.show();
  return app.exec();
}
