#ifndef QRK_CONDITION_VARIABLE_H
#define QRK_CONDITION_VARIABLE_H

/*!
  \file
  \brief 条件変数

  \author Satofumi KAMIMURA

  $Id: ConditionVariable.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include <memory>


namespace qrk
{
    class Lock;

    //! 条件変数
    class ConditionVariable
    {
    public:
        enum {
            NoTimeout = -1,
        };
        ConditionVariable(void);
        ~ConditionVariable(void);

        bool isWaiting(void);
        void wakeup(void);
        void wakeupAll(void);

        bool wait(Lock* lock, int timeout = NoTimeout);

    private:
        ConditionVariable(const ConditionVariable& rhs);
        ConditionVariable& operator = (const ConditionVariable& rhs);

        struct pImpl;
        const std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_CONDITION_VARIABLE_H */
