#ifndef SCIP_PLAYER_WINDOW_H
#define SCIP_PLAYER_WINDOW_H

/*!
  \file
  \brief SCIP データの表示ウィンドウ

  \author Satofumi KAMIMURA

  $Id: ScipPlayerWindow.h 1829 2010-05-20 04:48:55Z satofumi $
*/

#include "ui_ScipPlayerWindowForm.h"
#include <memory>


/*!
  \brief SCIP データの表示用ウィンドウ
*/
class ScipPlayerWindow : public QMainWindow, private Ui::ScipPlayerWindowForm
{
    Q_OBJECT;

    ScipPlayerWindow(const ScipPlayerWindow& rhs);
    ScipPlayerWindow& operator = (const ScipPlayerWindow& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

protected slots:
    void aboutApplication(void);
    void pathPressed(void);
    void reloadPressed(void);
    void nextPressed(void);
    void continuousPressed(void);
    void timerTimeout(void);
    void dragEnterEvent(QDragEnterEvent* event);
    void dropEvent(QDropEvent* event);
    void zoomSmaller(void);
    void zoomLarger(void);
    void initializeView(void);

public:
    ScipPlayerWindow(void);
    ~ScipPlayerWindow(void);
};

#endif /* !SCIP_PLAYER_WINDOW_H */
