/*!
  \file
  \brief SCIP 文字列を入力し、結果を表示するフォーム

  \author Satofumi KAMIMURA

  $Id: InputWidget.cpp 1779 2010-04-15 03:17:57Z satofumi $
*/

#include "InputWidget.h"
#include <QShortcut>
#include <string>

using namespace std;


namespace
{
  long decode(const char* data, size_t size)
  {
    const char* p = data;
    const char* last_p = p + size;

    int value = 0;
    while (p < last_p) {
      value <<= 6;
      value &= ~0x3f;
      value |= *p++ - 0x30;
    }
    return value;
  }
}


struct InputWidget::pImpl
{
  InputWidget* widget_;


  pImpl(InputWidget* widget) : widget_(widget)
  {
  }


  void initializeForm(void)
  {
    // イベント割り付け
    connect(widget_->input_lineedit_, SIGNAL(textChanged(const QString&)),
            widget_, SLOT(inputChanged(const QString&)));

    // ショートカット割り付け
    (void) new QShortcut(Qt::CTRL + Qt::Key_Q, widget_, SLOT(close()));
  }
};


InputWidget::InputWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl(this))
{
  setupUi(this);
  pimpl->initializeForm();
}


InputWidget::~InputWidget(void)
{
}


void InputWidget::inputChanged(const QString& text)
{
  if (text.isEmpty()) {
    result_lineedit_->clear();
    return;
  }

  string string_text = text.toStdString();
  long value = decode(string_text.c_str(), string_text.size());
  result_lineedit_->setText(QString("%1").arg(value));
}
