#ifndef DRAW_WIDGET_H
#define DRAW_WIDGET_H

/*!
  \file
  \brief データ描画ウィジット

  \author Satofumi KAMIMURA

  $Id: DrawWidget.h 994 2009-06-13 09:29:40Z satofumi $
*/

#include <QWidget>
#include <memory>

namespace qrk
{
  class RangeSensor;
}

class UrgStateWidget;


class DrawWidget : public QWidget
{
  Q_OBJECT;

  DrawWidget(const DrawWidget& rhs);
  DrawWidget& operator = (const DrawWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void closeEvent(QCloseEvent* event);
  void quitPressed(void);
  void initializeView(void);
  void zoomSmaller(void);
  void zoomLarger(void);


public:
  DrawWidget(QWidget* parent = 0);
  ~DrawWidget(void);

  void setTitle(const QString& title, UrgStateWidget* urg_state_widget);
  void setUrgData(std::vector<long>& data,
                  const qrk::RangeSensor* sensor, int timestamp,
                  UrgStateWidget* urg_state_widget);
  void disconnected(UrgStateWidget* urg_state_widget);

signals:
  void quit(void);
};

#endif /* !DRAW_WIDGET_H */
