/*!
  \file
  \brief 項目の並べ替えを行う Widget

  \author Satofumi KAMIMURA

  $Id: ItemShuffleWidget.cpp 1281 2009-09-08 17:56:36Z satofumi $
*/

#include "ItemShuffleWidget.h"
#include <QShortcut>
#include <map>
#include <string>

using namespace std;


struct ItemShuffleWidget::pImpl
{
  ItemShuffleWidget* widget_;
  vector<QString> names_;
  vector<QLabel*> labels_;


  pImpl(ItemShuffleWidget* widget) : widget_(widget)
  {
    // ランダムシードの初期化
    srand(time(NULL));

    // 項目をファイルから読み出し
    // !!!

    // !!! 仮初期化。実際にはファイルから読み出すこと
    names_.push_back("1");
    names_.push_back("2");
    names_.push_back("3");
    names_.push_back("4");
    names_.push_back("5");
    names_.push_back("6");
    names_.push_back("7");
    names_.push_back("8");
  }


  void initializeForm(void)
  {
    // ダミー表示を消去
    widget_->dummy_label_->hide();

    // 項目の数だけ label を作成して配置し、項目を表示する
    setItemLabels();
    showItems();

    // イベントの接続
    connect(widget_->shuffle_button_, SIGNAL(clicked()),
            widget_, SLOT(shufflePressed()));

    // Ctrl-q, Alt-F4 で終了させる
    (void) new QShortcut(Qt::CTRL + Qt::Key_Q, widget_, SLOT(close()));
    (void) new QShortcut(Qt::ALT + Qt::Key_F4, widget_, SLOT(close()));
  }


  void setItemLabels(void)
  {
    size_t n = names_.size();
    for (size_t i = 0; i < n; ++i) {
      QLabel* label = new QLabel(widget_);
      labels_.push_back(label);

      widget_->item_layout_->addWidget(label);
    }
  }


  void showItems(void)
  {
    size_t index = 0;
    for (vector<QString>::iterator it = names_.begin();
         it != names_.end(); ++it, ++index) {
      labels_[index]->setText(*it);
    }
  }


  void shuffleNames(void)
  {
    size_t n = names_.size();
    map<size_t, int> used;
    size_t used_size = 0;

    vector<QString> previous_names = names_;

    while (used_size < n) {
      size_t index = static_cast<size_t>(1.0 * n * rand() / (RAND_MAX + 1.0));
      if (used.find(index) == used.end()) {

        // 項目を登録
        names_[used_size] = previous_names[index];

        used[index] = 1;
        ++used_size;
      }
    }
  }
};


ItemShuffleWidget::ItemShuffleWidget(QWidget* widget)
  : QWidget(widget), pimpl(new pImpl(this))
{
  setupUi(this);
  pimpl->initializeForm();
}


ItemShuffleWidget::~ItemShuffleWidget(void)
{
}


void ItemShuffleWidget::shufflePressed(void)
{
  pimpl->shuffleNames();
  pimpl->showItems();
}
