#ifndef QRK_TEXT_SURFACE_H
#define QRK_TEXT_SURFACE_H

/*!
  \file
  \brief 文字列サーフェス

  \author Satofumi KAMIMURA

  $Id: TextSurface.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
    class Font;


    //! 文字列サーフェス
    class TextSurface : public Surface
    {
    public:
        explicit TextSurface(const Font& font, const char* text);
        ~TextSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

        static Rect<long> surfaceSize(Font& font, const char* text);

    private:
        TextSurface(void);
        TextSurface(const TextSurface& rhs);
        TextSurface& operator = (const TextSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_TEXT_SURFACE_H */
