#ifndef QRK_SWITCH_SURFACE_H
#define QRK_SWITCH_SURFACE_H

/*!
  \file
  \brief 表示内容を交換できるサーフェス

  \author Satofumi KAMIMURA

  $Id: SwitchSurface.h 1950 2011-05-07 08:18:39Z satofumi $
*/

#include "Surface.h"
#include <memory>
#include <cstddef>


namespace qrk
{
    //! 表示内容を交換できるサーフェス
    class SwitchSurface : public Surface
    {
    public:
        SwitchSurface(void);
        ~SwitchSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

        void addSurface(Surface& surface, size_t id);
        void removeSurface(size_t id);
        void setDrawSurface(size_t id);
        size_t currentSurfaceId(void);

    private:
        SwitchSurface(const SwitchSurface& rhs);
        SwitchSurface& operator = (const SwitchSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_SWITCH_SURFACE_H */
