#ifndef QRK_SDL_VIDEO_INIT_H
#define QRK_SDL_VIDEO_INIT_H

/*!
  \file
  \brief SDL_VIDEO システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlVideoInit.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include <memory>


namespace qrk
{
    //! SDL_VIDEO システムの初期化クラス
    class SdlVideoInit
    {
    public:
        SdlVideoInit(void);
        ~SdlVideoInit(void);


        /*!
          \brief システムの初期化
        */
        void initialize(void);


        /*!
          \brief システムの終了
        */
        void terminate(void);


    private:
        SdlVideoInit(const SdlVideoInit& rhs);
        SdlVideoInit& operator = (const SdlVideoInit& rhs);

        struct pImpl;
        const std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_SDL_VIDEO_INIT_H */
