/*!
  \file
  \brief SDL システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlInit.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "SdlInit.h"
#include <SDL.h>
#include <cstdlib>

using namespace qrk;


struct SdlInit::pImpl
{
    static bool initialized_;
};
bool SdlInit::pImpl::initialized_ = false;


SdlInit::SdlInit(void) : pimpl(new pImpl)
{
    if (pimpl->initialized_) {
        // 初期化済みならば、戻る
        return;
    }

    if (SDL_Init(0) < 0) {
        // !!! 例外を投げるべき
        return;
    }

    // OpenGL を利用したときに警告がでるため、コメントアウト
    //atexit(SDL_Quit);

    pimpl->initialized_ = true;
}


SdlInit::~SdlInit(void)
{
}
