#ifndef QRK_ROTATION_H
#define QRK_ROTATION_H

/*!
  \file
  \brief 回転

  \author Satofumi KAMIMURA

  $Id: Rotate.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "Position.h"
#include "Point.h"
#include "MathUtils.h"


namespace qrk
{
    /*!
      \brief 回転演算

      \param[in] position 回転前の位置
      \param[in] angle 回転させる角度

      \return 回転後の位置
    */
    template<class T>
    Position<T> rotate(const Position<T>& position, const Angle& angle)
    {
        double radian = angle.to_rad();
        T x = static_cast<T>((position.x * cos(radian))
                             - (position.y * sin(radian)));
        T y = static_cast<T>((position.x * sin(radian))
                             + (position.y * cos(radian)));

        return Position<T>(x, y, rad(position.angle.to_rad() + radian));
    }


    /*!
      \brief 回転演算

      \param[in] point 回転前の位置
      \param[in] angle 回転させる角度

      \return 回転後の位置
    */
    template<class T>
    Point<T> rotate(const Point<T>& point, const Angle& angle)
    {
        double radian = angle.to_rad();
        T x = static_cast<T>((point.x * cos(radian)) - (point.y * sin(radian)));
        T y = static_cast<T>((point.x * sin(radian)) + (point.y * cos(radian)));

        return Point<T>(x, y);
    }
}

#endif /* !QRK_ROTATION_H */
