#ifndef QRK_MULTI_SURFACE_H
#define QRK_MULTI_SURFACE_H

/*!
  \file
  \brief 複数サーフェスの合成

  \author Satofumi KAMIMURA

  $Id: MultiSurface.h 1813 2010-05-01 14:21:29Z satofumi $
*/

#include "Surface.h"
#include "Point.h"
#include <memory>

namespace qrk
{
    //! 複数サーフェスの合成
    class MultiSurface : public Surface
    {
    public:
        explicit MultiSurface(Surface& base_surface);
        ~MultiSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

        void push_front(Surface& surface, const Point<long>& offset);

    private:
        MultiSurface(void);
        MultiSurface(const MultiSurface& rhs);
        MultiSurface& operator = (const MultiSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_MULTI_SURFACE_H */
