#ifndef QRK_FONT_H
#define QRK_FONT_H

/*!
  \file
  \brief フォント設定

  \author Satofumi KAMIMURA

  $Id: Font.h 1820 2010-05-10 22:05:09Z satofumi $
*/

#include "Color.h"
#include <SDL_ttf.h>
#include <memory>


namespace qrk
{
    //! フォント資源クラス
    class Font
    {
    public:
        enum {
            DefaultSize = 16,         //!< [pixel]
        };

        /*!
          \brief 文字サーフェスの作成

          \attention デフォルトでは背景が透過したサーフェスが作られる。変更するには transparentize() を呼び出すこと
        */
        explicit Font(const char* font_file, size_t font_size = DefaultSize,
                      bool transparent = true);
        Font(const Font& rhs);
        ~Font(void);

        const char* what(void) const;

        Font duplicate(void);

        bool isValid(void) const;

        TTF_Font* resource(void) const;

        void setPixelSize(size_t font_size);
        size_t pixelSize(void) const;

        void setForegroundColor(const Color& color);
        Color foregroundColor(void) const;

        void setBackgroundColor(const Color& color);
        Color backgroundColor(void) const;

        void setTransparent(bool on = true);
        bool transparent(void) const;

    private:
        Font(void);
        Font& operator = (const Font& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_FONT_H */
