#ifndef QRK_COLOR_SURFACE_H
#define QRK_COLOR_SURFACE_H

/*!
  \file
  \brief 単色サーフェス

  \author Satofumi KAMIMURA

  $Id: ColorSurface.h 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "Surface.h"
#include <memory>


namespace qrk
{
    class Color;


    //! 単色サーフェス
    class ColorSurface : public Surface
    {
    public:
        explicit ColorSurface(const Rect<long>& rect, const Color& color);
        ~ColorSurface(void);

        bool isValid(void) const;
        Rect<long> rect(void) const;
        void setAlpha(float alpha);
        float alpha(void) const;
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>* src, const Rect<long>* dest);

    private:
        ColorSurface(const ColorSurface& rhs);
        ColorSurface& operator = (const ColorSurface& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_COLOR_SURFACE_H */
