/*!
  \file
  \brief 単色サーフェス

  \author Satofumi KAMIMURA

  $Id: ColorSurface.cpp 1966 2011-08-16 08:57:00Z satofumi $
*/

#include "ColorSurface.h"
#include "Color.h"
#include "log_printf.h"
#include "DetectOS.h"
#if defined(WINDOWS_OS)
#include <windows.h>
#endif
#define NO_SDL_GLEXT
#include <GL/glew.h>
#include <SDL_opengl.h>
#include <SDL.h>

using namespace qrk;


struct ColorSurface::pImpl
{
    Rect<long> rect_;
    Color color_;


    pImpl(const Rect<long>& rect, const Color& color)
        : rect_(rect), color_(color)
    {
        SDL_Surface* scr = SDL_GetVideoSurface();
        if (! (scr->flags & SDL_OPENGL)) {
            log_printf("OpenGL is not initialized: use Screen::show(SDL_OPENGL)\n");
        }
    }
};


ColorSurface::ColorSurface(const Rect<long>& rect, const Color& color)
    : pimpl(new pImpl(rect, color))
{
}


ColorSurface::~ColorSurface(void)
{
}


bool ColorSurface::isValid(void) const
{
    // 常に有効
    return true;
}


Rect<long> ColorSurface::rect(void) const
{
    return pimpl->rect_;
}


void ColorSurface::setAlpha(float alpha)
{
    pimpl->color_.a = alpha;
}


float ColorSurface::alpha(void) const
{
    return pimpl->color_.a;
}


void ColorSurface::setRotateAngle(const Angle& angle)
{
    (void)angle;
    // !!!
}


void ColorSurface::draw(const Rect<long>* src, const Rect<long>* dest)
{
    static_cast<void>(src);

    if (! dest) {
        return;
    }

    glColor4f(pimpl->color_.r, pimpl->color_.g, pimpl->color_.b,
              pimpl->color_.a);

    glBegin(GL_QUADS);
    glVertex2d(dest->x, dest->y);
    glVertex2d(dest->x, dest->y + dest->h);
    glVertex2d(dest->x + dest->w, dest->y + dest->h);
    glVertex2d(dest->x + dest->w, dest->y);
    glEnd();
}
