#ifndef QRK_CHAT_MESSAGE_H
#define QRK_CHAT_MESSAGE_H

/*!
  \file
  \brief チャット等のメッセージ表示用

  追加したメッセージの行毎の表示と、フェードアウトしながら表示を消すことができる。

  \author Satofumi KAMIMURA

  $Id: ChatMessage.h 1950 2011-05-07 08:18:39Z satofumi $
*/

#include "Component.h"
#include <memory>
#include <cstddef>


namespace qrk
{
    class Font;

    //! チャット等のメッセージ表示用
    class ChatMessage : public Component
    {
    public:
        explicit ChatMessage(Font& font, const Rect<long>& rect);
        ~ChatMessage(void);

        Rect<long> rect(void) const;
        void setEventAcceptable(bool acceptable);
        void setAlpha(float alpha);
        float alpha(void);
        void setRotateAngle(const Angle& angle);
        void draw(const Rect<long>& area);

        void setDrawTimeout(size_t msec);
        void setFadeoutTime(size_t msec);
        void setOffset(const Point<long>& offset);

        void clear(void);
        void print(const char* text);
        void newline(void);

    private:
        ChatMessage(void);
        ChatMessage(const ChatMessage& rhs);
        ChatMessage& operator = (ChatMessage& rhs);

        struct pImpl;
        std::auto_ptr<pImpl> pimpl;
    };
}

#endif /* !QRK_CHAT_MESSAGE_H */
