#ifndef QRK_ALIGN_UTILS_H
#define QRK_ALIGN_UTILS_H

/*!
  \file
  \brief 位置揃え用の関数

  \author Satofumi KAMIMURA

  $Id: AlignUtils.h 1815 2010-05-06 17:34:19Z satofumi $
*/

namespace qrk
{
    class Component;
    class Surface;


    /*!
      \brief 左揃えの位置を返す

      左揃えの場合、x の位置をそのまま返す

      \param[in] component コンポーネント
      \param[in] x コンポーネントの位置

      \return コンポーネントを左揃えで配置するときの位置
    */
    extern long left(const Component& component, long x);


    /*!
      \brief 中央揃えの位置を返す

      \param[in] component コンポーネント
      \param[in] x コンポーネントを配置する中央の位置

      \return コンポーネントを中央揃えで配置するときの位置
    */
    extern long center(const Component& component, long x);


    /*!
      \brief 右揃えの位置を返す

      右揃えの場合、x の位置をそのまま返す

      \param[in] component コンポーネント
      \param[in] x コンポーネントの位置

      \return コンポーネントを右揃えで配置するときの位置
    */
    extern long right(const Component& component, long x);


    /*!
      \brief 上段揃えの位置を返す

      上段揃えの場合、y の位置をそのまま返す

      \param[in] component コンポーネント
      \param[in] y コンポーネントの位置

      \return コンポーネントを上段揃えで配置するときの位置
    */
    extern long top(const Component& component, long y);


    /*!
      \brief 中段揃えの位置を返す

      \param[in] component コンポーネント
      \param[in] y コンポーネントの位置

      \return コンポーネントを中段揃えで配置するときの位置
    */
    extern long middle(const Component& component, long y);


    /*!
      \brief 下段揃えの位置を返す

      \param[in] component コンポーネント
      \param[in] y コンポーネントの位置

      \return コンポーネントを下段揃えで配置するときの位置
    */
    extern long bottom(const Component& component, long y);


    //! \overload
    extern long left(const Surface& component, long x);

    //! \overload
    extern long center(const Surface& component, long x);

    //! \overload
    extern long right(const Surface& component, long x);

    //! \overload
    extern long top(const Surface& component, long y);

    //! \overload
    extern long middle(const Surface& component, long y);

    //! \overload
    extern long bottom(const Surface& component, long y);
};

#endif /* !QRK_ALIGN_UTILS_H */
