#ifndef INPUT_HANDLER_H
#define INPUT_HANDLER_H

/*!
  \file
  \brief 入力の受け付け

  \author Satofumi KAMIMURA

  $Id: InputHandler.h 798 2009-05-05 23:20:05Z satofumi $
*/

#include "Point.h"
#include <memory>


/*!
  \brief 入力の受け付け
*/
class InputHandler
{
  InputHandler(const InputHandler& rhs);
  InputHandler& operator = (const InputHandler& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:
  InputHandler(void);
  ~InputHandler(void);

  void update(void);
  bool isQuit(void);
  bool leftClicked(void);
  bool rightClicked(void);
  void setCursorPosition(const qrk::Point<long>& position);
  qrk::Point<long> cursorPosition(void);
};

#endif /* !INPUT_HANDLER_H */
