/*!
  \file
  \brief 画像の取得サンプル

  \author Satofumi KAMIMURA

  $Id: captureSample.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "CameraDevice.h"
#include "delay.h"
#include <cstdio>
#include <cstdlib>

using namespace qrk;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  CameraDevice camera;
  if (! camera.connect()) {
    printf("CameraDevice::connect fail.\n");
    exit(1);
  }
  camera.setCaptureSize(320, 240);

  for (int i = 0; i < 100; ++i) {
    delay(1000);

    enum { BufferSize = 80 };
    char buffer[BufferSize];
    snprintf(buffer, BufferSize, "capture%d.jpg", i);

    if (! camera.capture(buffer)) {
      fprintf(stderr, "capture fail.\n");
      break;
    }
    printf("capture: %s\n", buffer);
  }
  return 0;
}
