/*!
  \example set_timestamp.cpp タイムスタンプの設定サンプル

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TimestampManager.h"
#include "UrgDevice.h"
#include "ticks.h"
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
    static_cast<void>(argc);
    static_cast<void>(argv);

    UrgDevice urg;
    if (! urg.connect("/dev/ttyACM0")) {
        cout << "UrgDevice::connect: " << urg.what() << endl;
        return 1;
    }

    TimestampManager timestamp_manager;
    timestamp_manager.add(&urg);

    cout << timestamp_manager.timestamp(&urg) << endl;

    timestamp_manager.setTimestamp(0);
    cout << timestamp_manager.timestamp(&urg) << endl;

    timestamp_manager.setTimestamp(ticks());
    cout << ticks() << ", ";
    cout << timestamp_manager.timestamp(&urg) << ", ";
    cout << ticks() << ", " << endl;

    return 0;
}
